/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.diff;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.SingleTokenScanner;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.SubPartitionScanner;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import java.util.ArrayList;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.source.ISourceViewer;

public class DiffSourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    private static final String META_SEPARATOR_DIFF = "meta.separator.diff";
    private static final String META_DIFF_RANGE = "meta.diff.range";
    private static final String META_DIFF_INDEX = "meta.diff.index";
    private static final String META_DIFF_HEADER = "meta.diff.header";
    private static final String MARKUP_DELETED_DIFF = "markup.deleted.diff";
    private static final String MARKUP_CHANGED_DIFF = "markup.changed.diff";
    private static final String MARKUP_INSERTED_DIFF = "markup.inserted.diff";
    private static final String SOURCE_DIFF = "source.diff";
    public static final String PREFIX = "__diff_";
    public static final String DEFAULT = "__diff___dftl_partition_content_type";
    public static final String INSERTED = "__diff_inserted";
    public static final String CHANGED = "__diff_changed";
    public static final String DELETED = "__diff_deleted";
    public static final String HEADER = "__diff_header";
    public static final String INDEX = "__diff_index";
    public static final String RANGE = "__diff_range";
    public static final String SEPARATOR = "__diff_separator";
    public static final String[] CONTENT_TYPES = new String[]{"__diff___dftl_partition_content_type", "__diff_inserted", "__diff_changed", "__diff_deleted", "__diff_header", "__diff_index", "__diff_range", "__diff_separator"};
    private static final String[][] TOP_CONTENT_TYPES = new String[][]{{"com.aptana.contenttype.diff"}};
    private IPredicateRule[] partitioningRules;
    private static DiffSourceConfiguration instance;

    static {
        IContentTypeTranslator c = CommonEditorPlugin.getDefault().getContentTypeTranslator();
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.diff"}), new QualifiedContentType(new String[]{SOURCE_DIFF}));
        c.addTranslation(new QualifiedContentType(new String[]{INSERTED}), new QualifiedContentType(new String[]{MARKUP_INSERTED_DIFF}));
        c.addTranslation(new QualifiedContentType(new String[]{CHANGED}), new QualifiedContentType(new String[]{MARKUP_CHANGED_DIFF}));
        c.addTranslation(new QualifiedContentType(new String[]{DELETED}), new QualifiedContentType(new String[]{MARKUP_DELETED_DIFF}));
        c.addTranslation(new QualifiedContentType(new String[]{HEADER}), new QualifiedContentType(new String[]{META_DIFF_HEADER}));
        c.addTranslation(new QualifiedContentType(new String[]{INDEX}), new QualifiedContentType(new String[]{META_DIFF_INDEX}));
        c.addTranslation(new QualifiedContentType(new String[]{RANGE}), new QualifiedContentType(new String[]{META_DIFF_RANGE}));
        c.addTranslation(new QualifiedContentType(new String[]{SEPARATOR}), new QualifiedContentType(new String[]{META_SEPARATOR_DIFF}));
    }

    public static DiffSourceConfiguration getDefault() {
        if (instance == null) {
            instance = new DiffSourceConfiguration();
        }
        return instance;
    }

    private DiffSourceConfiguration() {
        IToken changed = DiffSourceConfiguration.getToken(CHANGED);
        IToken deleted = DiffSourceConfiguration.getToken(DELETED);
        IToken inserted = DiffSourceConfiguration.getToken(INSERTED);
        IToken header = DiffSourceConfiguration.getToken(HEADER);
        IToken separator = DiffSourceConfiguration.getToken(SEPARATOR);
        IToken range = DiffSourceConfiguration.getToken(RANGE);
        ArrayList<EndOfLineRule> rules = new ArrayList<EndOfLineRule>();
        EndOfLineRule rule = new EndOfLineRule("Index: ", DiffSourceConfiguration.getToken(INDEX));
        rule.setColumnConstraint(0);
        rules.add(rule);
        rule = new EndOfLineRule("@@", range);
        rule.setColumnConstraint(0);
        rules.add(rule);
        rule = new EndOfLineRule("--- ", header);
        rule.setColumnConstraint(0);
        rules.add(rule);
        rule = new EndOfLineRule("*** ", header);
        rule.setColumnConstraint(0);
        rules.add(rule);
        rule = new EndOfLineRule("==== ", header);
        rule.setColumnConstraint(0);
        rules.add(rule);
        rule = new EndOfLineRule("+++ ", header);
        rule.setColumnConstraint(0);
        rules.add(rule);
        rule = new SingleLineRule(" - ", " ====", header, '\u0000', true);
        rule.setColumnConstraint(0);
        rules.add(rule);
        rule = new PatternRule("===================================================================", null, separator, '\u0000', true);
        rule.setColumnConstraint(0);
        rules.add(rule);
        rule = new PatternRule("***************", null, separator, '\u0000', true);
        rule.setColumnConstraint(0);
        rules.add(rule);
        rule = new PatternRule("---", null, separator, '\u0000', true);
        rule.setColumnConstraint(0);
        rules.add(rule);
        rule = new EndOfLineRule("+", inserted);
        rule.setColumnConstraint(0);
        rules.add(rule);
        rule = new EndOfLineRule(">", inserted);
        rule.setColumnConstraint(0);
        rules.add(rule);
        rule = new EndOfLineRule("!", changed);
        rule.setColumnConstraint(0);
        rules.add(rule);
        rule = new EndOfLineRule("-", deleted);
        rule.setColumnConstraint(0);
        rules.add(rule);
        rule = new EndOfLineRule("<", deleted);
        rule.setColumnConstraint(0);
        rules.add(rule);
        this.partitioningRules = new IPredicateRule[rules.size()];
        rules.toArray(this.partitioningRules);
    }

    public String[] getContentTypes() {
        return CONTENT_TYPES;
    }

    public String[][] getTopContentTypes() {
        return TOP_CONTENT_TYPES;
    }

    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new SubPartitionScanner(this.partitioningRules, CONTENT_TYPES, DiffSourceConfiguration.getToken(DEFAULT));
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return "com.aptana.contenttype.diff";
        }
        return null;
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer(this.getOneTokenScanner(SOURCE_DIFF));
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)dr, DEFAULT);
        dr = new ThemeingDamagerRepairer(this.getOneTokenScanner(MARKUP_INSERTED_DIFF));
        reconciler.setDamager((IPresentationDamager)dr, INSERTED);
        reconciler.setRepairer((IPresentationRepairer)dr, INSERTED);
        dr = new ThemeingDamagerRepairer(this.getOneTokenScanner(MARKUP_CHANGED_DIFF));
        reconciler.setDamager((IPresentationDamager)dr, CHANGED);
        reconciler.setRepairer((IPresentationRepairer)dr, CHANGED);
        dr = new ThemeingDamagerRepairer(this.getOneTokenScanner(MARKUP_DELETED_DIFF));
        reconciler.setDamager((IPresentationDamager)dr, DELETED);
        reconciler.setRepairer((IPresentationRepairer)dr, DELETED);
        dr = new ThemeingDamagerRepairer(this.getOneTokenScanner(META_DIFF_HEADER));
        reconciler.setDamager((IPresentationDamager)dr, HEADER);
        reconciler.setRepairer((IPresentationRepairer)dr, HEADER);
        dr = new ThemeingDamagerRepairer(this.getOneTokenScanner(META_DIFF_INDEX));
        reconciler.setDamager((IPresentationDamager)dr, INDEX);
        reconciler.setRepairer((IPresentationRepairer)dr, INDEX);
        dr = new ThemeingDamagerRepairer(this.getOneTokenScanner(META_DIFF_RANGE));
        reconciler.setDamager((IPresentationDamager)dr, RANGE);
        reconciler.setRepairer((IPresentationRepairer)dr, RANGE);
        dr = new ThemeingDamagerRepairer(this.getOneTokenScanner(META_SEPARATOR_DIFF));
        reconciler.setDamager((IPresentationDamager)dr, SEPARATOR);
        reconciler.setRepairer((IPresentationRepairer)dr, SEPARATOR);
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        return new CommonContentAssistProcessor(editor);
    }

    private ITokenScanner getOneTokenScanner(String token) {
        return new SingleTokenScanner(DiffSourceConfiguration.getToken(token));
    }

    private static IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }
}

